/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.LogicalWorkspaceEvent;
import apiipc.generated.events.LogicalWorkspaceEventListener;
import apiipc.generated.ui.LogicalWorkspace;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalWorkspaceEventRegistry
extends IPCEventRegistry {
    protected Set<LogicalWorkspaceEventListener> globalListeners = new HashSet<LogicalWorkspaceEventListener>();
    protected Map<String, Set<LogicalWorkspaceEventListener>> specificObjectListeners = new HashMap<String, Set<LogicalWorkspaceEventListener>>();

    public LogicalWorkspaceEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "LogicalWorkspace";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        LogicalWorkspaceEvent logicalWorkspaceEvent = null;
        if (string.equalsIgnoreCase("deviceAdded")) {
            logicalWorkspaceEvent = new LogicalWorkspaceEvent.DeviceAdded(iPCEventLTV);
        } else if (string.equalsIgnoreCase("deviceRemoved")) {
            logicalWorkspaceEvent = new LogicalWorkspaceEvent.DeviceRemoved(iPCEventLTV);
        } else if (string.equalsIgnoreCase("remoteNetworkAdded")) {
            logicalWorkspaceEvent = new LogicalWorkspaceEvent.RemoteNetworkAdded(iPCEventLTV);
        } else if (string.equalsIgnoreCase("remoteNetworkRemoved")) {
            logicalWorkspaceEvent = new LogicalWorkspaceEvent.RemoteNetworkRemoved(iPCEventLTV);
        } else if (string.equalsIgnoreCase("linkCreated")) {
            logicalWorkspaceEvent = new LogicalWorkspaceEvent.LinkCreated(iPCEventLTV);
        } else if (string.equalsIgnoreCase("linkDeleted")) {
            logicalWorkspaceEvent = new LogicalWorkspaceEvent.LinkDeleted(iPCEventLTV);
        } else {
            return;
        }
        for (LogicalWorkspaceEventListener object : this.globalListeners) {
            object.handleEvent(logicalWorkspaceEvent);
        }
        Set<LogicalWorkspaceEventListener> set = this.specificObjectListeners.get(logicalWorkspaceEvent.objectUUID.toString());
        if (set != null) {
            for (LogicalWorkspaceEventListener logicalWorkspaceEventListener : set) {
                logicalWorkspaceEventListener.handleEvent(logicalWorkspaceEvent);
            }
        }
    }

    public void addListenerFiltered(LogicalWorkspaceEventListener logicalWorkspaceEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("deviceAdded");
                this.register("deviceRemoved");
                this.register("remoteNetworkAdded");
                this.register("remoteNetworkRemoved");
                this.register("linkCreated");
                this.register("linkDeleted");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(logicalWorkspaceEventListener);
    }

    public void addSpecificListenerFiltered(LogicalWorkspaceEventListener logicalWorkspaceEventListener, LogicalWorkspace logicalWorkspace, List<String> list) throws IOException {
        UUID uUID = logicalWorkspace.getObjectUUID();
        String string = uUID.toString();
        Set<LogicalWorkspaceEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<LogicalWorkspaceEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "deviceAdded");
                this.register(uUID, "deviceRemoved");
                this.register(uUID, "remoteNetworkAdded");
                this.register(uUID, "remoteNetworkRemoved");
                this.register(uUID, "linkCreated");
                this.register(uUID, "linkDeleted");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(uUID, list.get(i));
                }
            }
        }
        set.add(logicalWorkspaceEventListener);
    }

    public void removeListenerFiltered(LogicalWorkspaceEventListener logicalWorkspaceEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (list == null) {
                this.deregister("deviceAdded");
                this.deregister("deviceRemoved");
                this.deregister("remoteNetworkAdded");
                this.deregister("remoteNetworkRemoved");
                this.deregister("linkCreated");
                this.deregister("linkDeleted");
            }
            this.globalListeners.remove(logicalWorkspaceEventListener);
        }
    }

    public void removeSpecificListenerFiltered(LogicalWorkspaceEventListener logicalWorkspaceEventListener, LogicalWorkspace logicalWorkspace, List<String> list) throws IOException {
        UUID uUID = logicalWorkspace.getObjectUUID();
        String string = uUID.toString();
        Set<LogicalWorkspaceEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && !set.isEmpty()) {
            this.deregister(uUID, "deviceAdded");
            this.deregister(uUID, "deviceRemoved");
            this.deregister(uUID, "remoteNetworkAdded");
            this.deregister(uUID, "remoteNetworkRemoved");
            this.deregister(uUID, "linkCreated");
            this.deregister(uUID, "linkDeleted");
            set.remove(logicalWorkspaceEventListener);
        }
    }

    public void addListener(LogicalWorkspaceEventListener logicalWorkspaceEventListener) throws IOException {
        this.addListenerFiltered(logicalWorkspaceEventListener, null);
    }

    public void addListener(LogicalWorkspaceEventListener logicalWorkspaceEventListener, LogicalWorkspace logicalWorkspace) throws IOException {
        this.addSpecificListenerFiltered(logicalWorkspaceEventListener, logicalWorkspace, null);
    }

    public void removeListener(LogicalWorkspaceEventListener logicalWorkspaceEventListener) throws IOException {
        this.removeListenerFiltered(logicalWorkspaceEventListener, null);
    }

    public void removeListener(LogicalWorkspaceEventListener logicalWorkspaceEventListener, LogicalWorkspace logicalWorkspace) throws IOException {
        this.removeSpecificListenerFiltered(logicalWorkspaceEventListener, logicalWorkspace, null);
    }
}

